# 画面設計書 159-Cat セグメントレプリケーション

## 概要

本ドキュメントは、OpenSearchのCat Segment Replication API（`GET /_cat/segment_replication`）エンドポイントに関する画面設計書である。セグメントレプリケーションの進行状況をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：セグメントレプリケーション戦略を使用しているインデックスにおいて、レプリカシャードのセグメントレプリケーション状態を一覧形式で確認するために使用される。チェックポイントの遅延、バイト遅延、レプリケーションラグ、リジェクトリクエスト数などを監視し、レプリケーションの健全性を確認する。detailedパラメータで詳細なステージ別時間を含む追加情報を表示可能。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/segment_replication` または `GET /_cat/segment_replication/{index}` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. SegmentReplicationStatsRequestをインデックス管理APIに発行する
2. SegmentReplicationStatsResponseからグループごとのレプリケーション統計を取得する
3. シャードIDでソートし、各レプリカシャードのレプリケーション状態をテーブル行として構築する

**画面遷移**：本APIはステートレスなREST APIである。セグメントレプリケーション専用のAPIであり、従来のトランスログベースレプリケーションでは使用しない。

**権限による表示制御**：セキュリティプラグインが有効な場合、インデックスモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 108 | セグメントレプリケーション | 主機能 | セグメントレプリケーション状態をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のセグメントレプリケーション情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/segment_replication` | 全インデックスのセグメントレプリケーション情報を返す |
| GET | `/_cat/segment_replication/{index}` | 指定インデックスのセグメントレプリケーション情報を返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| index | list | No | - | インデックス名のカンマ区切りリスト（パスパラメータ） |
| format | string | No | - | レスポンス形式（json, yamlなど） |
| active_only | boolean | No | false | アクティブなレプリケーションのみ表示 |
| bytes | enum | No | - | バイト値の表示単位 |
| detailed | boolean | No | false | 詳細情報（ステージ別時間）を含む |
| shards | list | No | - | 表示対象シャードのカンマ区切りリスト |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | - | 時間値の表示単位 |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |
| allow_no_indices | boolean | No | - | インデックスが存在しない場合にエラーを返さない |
| expand_wildcards | enum | No | - | ワイルドカード展開対象 |
| ignore_unavailable | boolean | No | - | 利用不可インデックスを無視 |
| ignore_throttled | boolean | No | - | スロットル中インデックスを無視 |
| timeout | time | No | - | タイムアウト |

## 表示項目

### 基本カラム（常に表示）

| カラム名 | エイリアス | 説明 |
|---------|-----------|------|
| shardId | s | シャードID |
| target_node | tnode | ターゲットノード名 |
| target_host | thost | ターゲットホスト名 |
| checkpoints_behind | cpb | プライマリからのチェックポイント遅延数 |
| bytes_behind | bb | プライマリからのバイト遅延量 |
| current_lag | clag | レプリカがプライマリに追いつくまでの現在の遅延時間 |
| last_completed_lag | lcl | 最後に完了したレプリケーションのラグ時間 |
| rejected_requests | rr | リジェクトされたリクエスト数 |

### 詳細カラム（detailed=true時のみ表示）

| カラム名 | エイリアス | 説明 |
|---------|-----------|------|
| stage | st | セグメントレプリケーションのステージ |
| time | t,ti | 現在のレプリケーションイベント時間 |
| files_fetched | ff | フェッチ済みファイル数 |
| files_percent | fp | ファイルフェッチ進捗率 |
| bytes_fetched | bf | フェッチ済みバイト数 |
| bytes_percent | bp | バイトフェッチ進捗率 |
| start_time | start | レプリケーション開始時刻 |
| stop_time | stop | レプリケーション停止時刻 |
| files | f | フェッチ対象ファイル数 |
| files_total | tf | 総ファイル数 |
| bytes | b | フェッチ対象バイト数 |
| bytes_total | tb | 総バイト数 |
| replicating_stage_time_taken | rstt | レプリケーティングステージ所要時間 |
| get_checkpoint_info_stage_time_taken | gcistt | チェックポイント情報取得ステージ所要時間 |
| file_diff_stage_time_taken | fdstt | ファイル差分ステージ所要時間 |
| get_files_stage_time_taken | gfstt | ファイル取得ステージ所要時間 |
| finalize_replication_stage_time_taken | frstt | レプリケーション完了ステージ所要時間 |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestCatSegmentReplicationAction.doCatRequest()` が呼び出される。SegmentReplicationStatsRequestを生成し、セグメントレプリケーション統計を取得する。レスポンスからシャードIDでソートされたレプリケーション状態のテーブルを構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | レプリケーション情報取得成功時 | テーブル形式のレプリケーション情報 |
| 正常応答 | レプリケーションが0件の場合 | 空のレスポンス |

## 例外処理

- セグメントレプリケーション状態がnullのシャード：スキップされる（行163-165のnullチェック）
- セグメントレプリケーション未使用のインデックス：空のレスポンスが返される

## 備考

- detailedパラメータでステージ別の所要時間が追加表示される（5つのステージ）
- shardsパラメータで表示対象シャードをフィルタリング可能
- 進捗率は"X.X%"形式で表示される
- シャードIDの昇順でソートされる（CollectionUtil.introSort）
- セグメントレプリケーション戦略を使用していないインデックスでは情報が返されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SegmentReplicationPerGroupStats.java | `server/src/main/java/org/opensearch/index/SegmentReplicationPerGroupStats.java` | getShardId(), getReplicaStats(), getRejectedRequestCount()を保持 |
| 1-2 | SegmentReplicationShardStats.java | `server/src/main/java/org/opensearch/index/SegmentReplicationShardStats.java` | getCheckpointsBehindCount(), getBytesBehindCount(), getCurrentReplicationState()を保持 |
| 1-3 | SegmentReplicationState.java | `server/src/main/java/org/opensearch/indices/replication/SegmentReplicationState.java` | getStage(), getTimer(), getIndex(), ステージ別時間メソッドを保持 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCatSegmentReplicationAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` | Cat Segment Replication APIのエントリーポイント |

**主要処理フロー**:
1. **行49-53**: `routes()` で2つのルート登録
2. **行67-85**: `doCatRequest()` でSegmentReplicationStatsRequestを生成・発行
3. **行88-126**: `getTableWithHeader()` で基本8カラム + 詳細17カラムのテーブルヘッダー定義
4. **行136-202**: `buildSegmentReplicationTable()` でグループ・シャードごとにテーブル構築

### プログラム呼び出し階層図

```
RestCatSegmentReplicationAction.doCatRequest() [行67]
    |
    +-- SegmentReplicationStatsRequest(indices) [行68-69]
    |
    +-- client.admin().indices().segmentReplicationStats() [行77-79]
           |
           +-- buildSegmentReplicationTable() [行136]
                  +-- getTableWithHeader() [行88]
                  +-- CollectionUtil.introSort() [行151]
                  +-- SegmentReplicationShardStats -> テーブル行変換 [行161-196]
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

GET /_cat/segment_replication   --> RestCatSegmentReplicationAction          --> テーブル形式
GET /_cat/segment_replication/{i}    |
    ?detailed=true                   v
                               SegmentReplicationStatsRequest
                                    |
                                    v
                               SegmentReplicationStatsResponse
                                    |
                                    v
                               SegmentReplicationPerGroupStats (グループごと)
                                    |
                                    v
                               introSort (シャードIDでソート)
                                    |
                                    v
                               SegmentReplicationShardStats (レプリカごと)
                                    |
                                    v
                               buildSegmentReplicationTable()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestCatSegmentReplicationAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCatSegmentReplicationAction.java` | ソース | Cat Segment Replication APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| SegmentReplicationPerGroupStats.java | `server/src/main/java/org/opensearch/index/SegmentReplicationPerGroupStats.java` | ソース | グループ別レプリケーション統計 |
| SegmentReplicationShardStats.java | `server/src/main/java/org/opensearch/index/SegmentReplicationShardStats.java` | ソース | シャード別レプリケーション統計 |
| SegmentReplicationState.java | `server/src/main/java/org/opensearch/indices/replication/SegmentReplicationState.java` | ソース | レプリケーション状態データ構造 |
| cat.segment_replication.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.segment_replication.json` | 設定 | REST API仕様定義 |
